from fastapi import APIRouter, Depends, HTTPException, status, Header
from sqlalchemy.orm import Session
from app.database.connection import SessionLocal
from app.models.user import User
from app.schemas.user_schema import UserCreate, UserLogin
from passlib.context import CryptContext
from jose import JWTError, jwt
import datetime
from pydantic import BaseModel
from typing import Optional

router = APIRouter(prefix="", tags=["User"])

def get_db():
    db = SessionLocal()
    try:
        yield db
    finally:
        db.close()

@router.put("/delete_user/{user_id}")
def edit_user(
    user_id: int,
    db: Session = Depends(get_db),
    access_token: Optional[str] = Header(None)
):
    if not access_token:
        return {"status":"false", "message": "Access token missing"}
    
    existing_user = db.query(User).filter(User.id == user_id).first()
    if not existing_user:
        return {"status":"false", "message": "User not found"}

    db.delete(existing_user)
    db.commit()

    return {"status":"true","message": "User deleted successfully"}