from fastapi import APIRouter, Depends, HTTPException, status, Header
from sqlalchemy.orm import Session
from app.database.connection import SessionLocal
from app.models.user import User
from app.schemas.user_schema import UserCreate, UserLogin
from passlib.context import CryptContext
from jose import JWTError, jwt
import datetime
from pydantic import BaseModel
from typing import Optional

router = APIRouter(prefix="", tags=["User"])

def get_db():
    db = SessionLocal()
    try:
        yield db
    finally:
        db.close()

@router.get("/get_users")
def get_all_users(
    db: Session = Depends(get_db),
    access_token: Optional[str] = Header(None)
):
    if not access_token:
        return {"status":"false", "message": "Access token missing"}
    
    users = db.query(User).all()
    if not users:
        return {"status": "false", "message": "No users found"}
    
    user_list = []
    for user in users:
        user_list.append({
            "id": user.id,
            "username": user.username,
            "title": user.title,
            "first_name": user.first_name,
            "last_name": user.last_name,
            "email": user.email,
            "telephone_number": user.telephone_number,
            "role_id": user.role_id,
            "speciality": user.speciality,
        })
    
    return {"status": "true", "message": "Users fetched successfully", "records": user_list}