from fastapi import FastAPI
from app.database.connection import Base, engine
from app.models.user import User
from app.routes import auth
from app.routes.user import create_user
from app.routes.user import edit_user
from app.routes.user import delete_user
from app.routes.user import get_users
from app.routes.user import change_password

app = FastAPI()

Base.metadata.create_all(bind=engine)

from fastapi.middleware.cors import CORSMiddleware

app.add_middleware(
    CORSMiddleware,
    allow_origins=["http://localhost:5173"],  # or ["http://localhost:5173"] for Vite
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

app.include_router(auth.router)
app.include_router(create_user.router)
app.include_router(edit_user.router)
app.include_router(delete_user.router)
app.include_router(get_users.router)
app.include_router(change_password.router)

# @app.get("/")
# def read_root():
#     return {"message": "FastAPI is running 🚀"}